(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6552,        239]*)
(*NotebookOutlinePosition[      7396,        266]*)
(*  CellTagsIndexPosition[      7352,        262]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 5.1 \( \(.1\)\(.\)\)\ *) \[IndentingNewLine]\(\[Phi][
          x_] := \ Sin[x];\)\[IndentingNewLine] (*\ 
      since\ \[Phi][x] = Sin[x], \ 
      we\ should\ take\ a0 = 0\ *) \), "\[IndentingNewLine]", 
    \(\(k[x_, s_] := \ 
        If[x \[LessEqual] \ s, \ x\ \((1 - s)\), \ 
          s \((1 - x)\)];\)\), "\[IndentingNewLine]", 
    \(Integrate[k[x, s]*\[Phi][s], \ {s, \ 0, \ 1}]\)}], "Input"],

Cell[BoxData[
    \(\[Integral]\_0\%1\( If[x \[LessEqual] s, x\ \((1 - s)\), 
            s\ \((1 - x)\)]\ Sin[s]\) \[DifferentialD]s\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((1 - x)\)*Integrate[s\ Sin[s], {s, 0, x}] + 
        x*\ Integrate[\((1 - s)\)\ Sin[s], \ {s, \ x, 1}] // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(\(-x\)\ Sin[1] + Sin[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(shiftedChev[n_, x_] := 
        ChebyshevT[n, 2\ x - 1];\)\), "\[IndentingNewLine]", 
    \(Table[shiftedChev[n, x], \ {n, 4}] // Simplify\)}], "Input"],

Cell[BoxData[
    \({\(-1\) + 2\ x, 
      1 - 8\ x + 8\ x\^2, \(-1\) + 18\ x - 48\ x\^2 + 32\ x\^3, 
      1 - 8\ \((1 - 2\ x)\)\^2 + 8\ \((1 - 2\ x)\)\^4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(shiftedChev[0, x] = 1;\)\), "\[IndentingNewLine]", 
    \(\(p[0, x] = 1;\)\), "\[IndentingNewLine]", 
    \(\(p[n_, \ x_] := \ x^n;\)\), "\[IndentingNewLine]", 
    \(\(q[n_, 
          x_] := \ \((1 - x)\)*Integrate[s\ *p[n, s], {s, 0, x}] + 
            x*\ Integrate[\((1 - s)\)*p[n, s], \ {s, \ x, 1}] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(q[0, x] // Simplify\)}], "Input"],

Cell[BoxData[
    \(\(-\(1\/2\)\)\ \((\(-1\) + x)\)\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[q[n, x], \ {n, 4}] // Simplify\)], "Input"],

Cell[BoxData[
    \({1\/6\ \((x - x\^3)\), 1\/12\ \((x - x\^4)\), 1\/20\ \((x - x\^5)\), 
      1\/30\ \((x - x\^6)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(b[i_, j_] := 
        Integrate[p[i, x]*p[j, x], \ {x, 0, 1}];\)\), "\[IndentingNewLine]", 
    \(matB = Table[b[i, j], \ {i, 4}, \ {j, 4}]\)}], "Input"],

Cell[BoxData[
    \({{1\/3, 1\/4, 1\/5, 1\/6}, {1\/4, 1\/5, 1\/6, 1\/7}, {1\/5, 1\/6, 1\/7, 
        1\/8}, {1\/6, 1\/7, 1\/8, 1\/9}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(a[i_, j_] := 
        Integrate[
          p[i, x]*q[j, x], \ {x, \ 0, 1}];\)\), "\[IndentingNewLine]", 
    \(matA = Table[a[i, j], \ {i, 4}, \ {j, 4}]\)}], "Input"],

Cell[BoxData[
    \({{1\/45, 1\/72, 1\/105, 1\/144}, {1\/72, 1\/112, 1\/160, 
        1\/216}, {1\/105, 1\/160, 1\/225, 1\/300}, {1\/144, 1\/216, 1\/300, 
        1\/396}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(f[x_] := \ x\ Sin[1];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c[n_] := \ 
        Integrate[f[x]*q[n, x], \ {x, \ 0, 1}];\)\), "\[IndentingNewLine]", 
    \(vectc = Table[c[n], \ {n, 4}]\)}], "Input"],

Cell[BoxData[
    \({Sin[1]\/45, Sin[1]\/72, Sin[1]\/105, Sin[1]\/144}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m = matB - matA\)], "Input"],

Cell[BoxData[
    \({{14\/45, 17\/72, 4\/21, 23\/144}, {17\/72, 107\/560, 77\/480, 
        209\/1512}, {4\/21, 77\/480, 218\/1575, 73\/600}, {23\/144, 
        209\/1512, 73\/600, 43\/396}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[m, vectc] // N\)], "Input"],

Cell[BoxData[
    \({0.15799270679003596`, 
      0.005061826716208222`, \(-0.18209880658268496`\), 
      0.01901051748918978`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ These\ are\ a1, \ a2, \ a3, \ a4\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(approxsolution[x_] := 
        0.15799270679003596`*x + 0.005061826716208222`\ *x^2\  - 
          0.18209880658268496`*x^3\  + 
          0.01901051748918978`*x^4;\)\), "\[IndentingNewLine]", 
    \(approxsolution[0]\)}], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(approxsolution[0.2]\)], "Input"],

Cell[BoxData[
    \(0.03037464080197675`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(approxsolution[0.4]\)], "Input"],

Cell[BoxData[
    \(0.05283932061703912`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(approxsolution[0.6]\)], "Input"],

Cell[BoxData[
    \(0.059748302536595584`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(approxsolution[0.8]\)], "Input"],

Cell[BoxData[
    \(0.04418585352363944`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(approxsolution[1.0]\)], "Input"],

Cell[BoxData[
    \(\(-0.00003375558725099079`\)\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{23, Automatic}, {40, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 437, 8, 91, "Input"],
Cell[2179, 61, 147, 2, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2363, 68, 156, 3, 43, "Input"],
Cell[2522, 73, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2616, 79, 175, 3, 43, "Input"],
Cell[2794, 84, 170, 3, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3001, 92, 421, 8, 123, "Input"],
Cell[3425, 102, 68, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3530, 108, 69, 1, 27, "Input"],
Cell[3602, 111, 132, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3771, 118, 176, 3, 43, "Input"],
Cell[3950, 123, 147, 2, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4134, 130, 189, 4, 43, "Input"],
Cell[4326, 136, 185, 3, 76, "Output"]
}, Open  ]],
Cell[4526, 142, 58, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4609, 147, 161, 3, 43, "Input"],
Cell[4773, 152, 84, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4894, 158, 48, 1, 27, "Input"],
Cell[4945, 161, 204, 3, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5186, 169, 59, 1, 27, "Input"],
Cell[5248, 172, 142, 3, 26, "Output"]
}, Open  ]],
Cell[5405, 178, 75, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[5505, 183, 254, 5, 107, "Input"],
Cell[5762, 190, 35, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5834, 196, 52, 1, 27, "Input"],
Cell[5889, 199, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5980, 205, 52, 1, 27, "Input"],
Cell[6035, 208, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6126, 214, 52, 1, 27, "Input"],
Cell[6181, 217, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6273, 223, 52, 1, 27, "Input"],
Cell[6328, 226, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6419, 232, 52, 1, 27, "Input"],
Cell[6474, 235, 62, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

